/*
 * Decompiled with CFR 0.152.
 */
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class Request {
    private String command;
    private Map<String, String> params;

    private static String decode(String str) {
        try {
            return URLDecoder.decode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static String encode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Request fromUrl(String url) {
        String[] requestParts = url.split("\\?");
        String command = requestParts[0];
        Request request = new Request(command);
        if (requestParts.length == 2) {
            String[] paramParts;
            String paramStr = requestParts[1];
            String[] stringArray = paramParts = paramStr.split("&");
            int n = paramParts.length;
            int n2 = 0;
            while (n2 < n) {
                String paramPart = stringArray[n2];
                String key = paramPart.split("=")[0];
                String value = "";
                if (paramPart.split("=").length == 2) {
                    value = paramPart.split("=")[1];
                }
                request.addRaw(key, value);
                ++n2;
            }
        }
        return request;
    }

    public Request(String cmd) {
        if (cmd == null) {
            throw new NullPointerException("null command verb passed");
        }
        this.command = this.sanitize(cmd).replace("?", "_").replace(" ", "_").replace("&", "_");
        this.params = new LinkedHashMap<String, String>();
    }

    public void addParam(String key, String value) {
        this.params.put(this.sanitize(key), Request.encode(value));
    }

    private void addRaw(String key, String value) {
        this.params.put(this.sanitize(key), value);
    }

    public String getCommand() {
        return this.command;
    }

    public String getParam(String key) {
        if (this.hasParam(key)) {
            return Request.decode(this.params.get(this.sanitize(key)));
        }
        return null;
    }

    public Iterator<String> getParamNames() {
        return this.params.keySet().iterator();
    }

    public boolean hasParam(String key) {
        return this.params.containsKey(this.sanitize(key));
    }

    public void removeParam(String key) {
        this.params.remove(this.sanitize(key));
    }

    private String sanitize(String key) {
        return String.valueOf(key).trim();
    }

    public String toGetRequest() {
        String getRequest = this.command;
        if (!this.params.isEmpty()) {
            boolean isFirst = true;
            for (String key : this.params.keySet()) {
                if (isFirst) {
                    getRequest = String.valueOf(getRequest) + "?" + key + "=" + this.params.get(key);
                    isFirst = false;
                    continue;
                }
                getRequest = String.valueOf(getRequest) + "&" + key + "=" + this.params.get(key);
            }
        }
        return getRequest;
    }

    public String toString() {
        String str = String.valueOf(this.command) + " (";
        boolean isFirst = true;
        for (String p : this.params.keySet()) {
            if (!isFirst) {
                str = String.valueOf(str) + ", ";
            }
            str = String.valueOf(str) + p + "=" + this.getParam(p);
            isFirst = false;
        }
        str = String.valueOf(str) + ")";
        return str;
    }
}

